# V3 Frontend Architecture

## What V3 Uses

- **KLineChart Pro** – Chart with BinanceDatafeed
- **Datafeed** – `getHistoryKLineData` (fapi.binance.com klines), `subscribe` (WebSocket for real-time candles)
- **Watchlist** – Right panel, localStorage, price polling

- **Symbol switching** – `switchSymbol` (500ms debounce), `change_symbol` / `change_timeframe` via WebSocket
- **Drawings** – Load, create, update, delete, save overlays via backend

- **Custom overlays** – fibonacciSegment, fibonacciExtension (override built-in)

## Section Structure (app.js)

1. IMPORTS
2. UTILITIES
3. DATAFEED & BINANCE
4. GLOBALS
5. WATCHLIST
6. SYMBOL SWITCHING
7. CHART UI HANDLERS
8. CONTEXT MENU
9. OVERLAYS
10. CHART HELPERS
11. DRAWINGS
12. CHART INIT
13. CHART BOOTSTRAP
14. TOOLBAR INJECTION
15. SYMBOL SEARCH INPUT
