# -*- mode: python ; coding: utf-8 -*-
import os
from PyInstaller.utils.hooks import collect_all

if not os.path.isdir('frontend/dist' ):
    raise SystemExit('ERROR: Run "npm run build" in frontend/ first.')

if not os.path.isfile('dist/obf/back_end_v4_4_gui_license.py'):
    raise SystemExit('ERROR: Obfuscated files not found')

datas_ws, binaries_ws, hidden_ws = collect_all('websockets')
datas_aio, binaries_aio, hidden_aio = collect_all('aiohttp' )

a = Analysis(
    ['dist/obf/back_end_v4_4_gui_license.py'],
    pathex=['dist/obf'],
    binaries=binaries_ws + binaries_aio,
    datas=[
        ('frontend', 'frontend'),
        ('dist/obf/pyarmor_runtime_009871', 'pyarmor_runtime_009871'),
    ] + datas_ws + datas_aio,
    hiddenimports=[
        'sys', 'webbrowser', 'time', 'asyncio', 'threading', 
        'http', 'http.server',
        'urllib', 'urllib.request', 'urllib.parse', 'urllib.error',
        'json', 'pathlib',
        'collections', 'collections.defaultdict', 'collections.deque', 'collections.OrderedDict',
        'datetime', 'os', 'uuid', 'hashlib', 'platform',
        'tkinter', 'tkinter.messagebox', '_tkinter',
        'license_validator_gui',
        'websockets', 'websockets.client', 'websockets.server',
        'websockets.legacy', 'websockets.legacy.client', 'websockets.legacy.server',
        'websockets.legacy.protocol', 'websockets.exceptions', 'websockets.protocol',
        'websockets.datastructures', 'websockets.frames', 'websockets.http',
        'websockets.http11', 'websockets.uri', 'websockets.typing',
        'aiohttp', 'aiohttp.client', 'aiohttp.client_exceptions',
        'aiohttp.connector', 'aiohttp.helpers', 'aiohttp.http',
        'aiohttp.streams', 'aiohttp.web',
    ] + hidden_ws + hidden_aio,
    hookspath=[],
    hooksconfig={},
    runtime_hooks=[],
    excludes=[],
    noarchive=False,
 )

pyz = PYZ(a.pure, a.zipped_data, cipher=None)

exe = EXE(
    pyz,
    a.scripts,
    [],
    exclude_binaries=True,
    name='InstitutionalCharts2026',
    debug=False,
    bootloader_ignore_signals=False,
    strip=False,
    upx=True,
    console=False,
)

coll = COLLECT(
    exe,
    a.binaries,
    a.zipfiles,
    a.datas,
    strip=False,
    upx=True,
    upx_exclude=[],
    name='InstitutionalCharts2026',
)

app = BUNDLE(
    coll,
    name='InstitutionalCharts2026.app',
    icon=None,
    bundle_identifier='com.elbaze.institutionalcharts',
    info_plist={
        'NSHighResolutionCapable': 'True',
        'LSMinimumSystemVersion': '10.13.0',
    },
)
