/**
 * One capture-phase click listener on chart container; handles symbol click only.
 * Must be registered before chart creation. Exposes register(containerElement, options).
 */
(function (global) {
    var options = {};

    function onChartContainerClick(e) {
        if (e.target.closest('.symbol')) {
            e.preventDefault();
            e.stopPropagation();
            if (typeof options.onSymbolClick === 'function') options.onSymbolClick();
            return;
        }
    }

    function register(containerElement, opts) {
        if (!containerElement) return;
        options = opts || {};
        containerElement.addEventListener('click', onChartContainerClick, true);
    }

    global.ChartIntercept = {
        register: register
    };
})(typeof window !== 'undefined' ? window : this);
