/**
 * Chart settings model: theme mode (dark/light) and candle preset.
 * KLineChart Pro: setTheme(theme), setStyles({ candle: { bar: { ... } } }).
 * Load/save localStorage; apply to mainChart only. No DOM - state and apply logic only.
 */
(function (global) {
    var STORAGE_THEME = 'chartThemeMode';
    var STORAGE_CANDLE = 'chartCandlePreset';

    var themeMode = 'dark';
    var candlePresetId = 'GR';
    var chartRefs = null;

    function load() {
        try {
            var m = localStorage.getItem(STORAGE_THEME);
            if (m === 'light' || m === 'dark') themeMode = m;
            var c = localStorage.getItem(STORAGE_CANDLE);
            if (c && global.ThemePresets && global.ThemePresets[c]) candlePresetId = c;
        } catch (e) { /* ignore */ }
    }

    function saveTheme() {
        try { localStorage.setItem(STORAGE_THEME, themeMode); } catch (e) { /* ignore */ }
    }
    function saveCandle() {
        try { localStorage.setItem(STORAGE_CANDLE, candlePresetId); } catch (e) { /* ignore */ }
    }

    function getThemeMode() {
        return themeMode;
    }
    function setThemeMode(mode) {
        if (mode !== 'dark' && mode !== 'light') return;
        themeMode = mode;
        saveTheme();
    }

    function getCandlePreset() {
        return candlePresetId;
    }
    function setCandlePreset(id) {
        if (!global.ThemePresets || !global.ThemePresets[id]) return;
        candlePresetId = id;
        saveCandle();
    }

    /** Returns preset object { name, upColor, downColor, ... } for current or given id */
    function getPreset(id) {
        var key = id != null ? id : candlePresetId;
        return global.ThemePresets ? (global.ThemePresets.getPreset ? global.ThemePresets.getPreset(key) : (global.ThemePresets[key] || global.ThemePresets['blue-red'])) : {};
    }

    function setChartRefs(refs) {
        chartRefs = refs;
    }

    function applyToCharts() {
        if (!chartRefs || !chartRefs.mainChart) return;
        var chart = chartRefs.mainChart;

        if (typeof chart.setTheme === 'function') {
            chart.setTheme(themeMode);
        }

        if (typeof chart.setStyles === 'function') {
            var preset = getPreset();
            var up = preset.upColor || '#2DC08E';
            var down = preset.downColor || '#F92855';
            var nc = '#888888';
            chart.setStyles({
                candle: {
                    bar: {
                        upColor: up,
                        downColor: down,
                        noChangeColor: nc,
                        upBorderColor: up,
                        downBorderColor: down,
                        noChangeBorderColor: nc,
                        upWickColor: up,
                        downWickColor: down,
                        noChangeWickColor: nc
                    }
                },
                indicator: {
                    bars: [{
                        upColor: up,
                        downColor: down,
                        noChangeColor: nc
                    }]
                }
            });
        }
    }

    load();

    global.ChartSettingsModel = {
        getThemeMode: getThemeMode,
        setThemeMode: setThemeMode,
        getCandlePreset: getCandlePreset,
        setCandlePreset: setCandlePreset,
        getPreset: getPreset,
        setChartRefs: setChartRefs,
        applyToCharts: applyToCharts
    };
})(typeof window !== 'undefined' ? window : this);
