/**
 * Candle color presets - 10 common combinations.
 * Each preset: id, code (2-letter), name, upColor, downColor.
 * Exposed on window for non-module use.
 */
(function (global) {
    var presets = [
        { id: 'GR', code: 'GR', name: 'Green Red',       upColor: '#4CAF50', downColor: '#FF5252' },
        { id: 'DG', code: 'DG', name: 'Dark GreenRed',   upColor: '#1E5C20', downColor: '#8B0000' },
        { id: 'BO', code: 'BO', name: 'Blue Orange',     upColor: '#00FFEF', downColor: '#FF9C00' },
        { id: 'WB', code: 'WB', name: 'White Black',     upColor: '#FFFFFF', downColor: '#000000' },
        { id: 'AW', code: 'AW', name: 'All White',       upColor: '#FFFFFF', downColor: '#FFFFFF' },
        { id: 'GB', code: 'GB', name: 'Gray Black',      upColor: '#D3D3D3', downColor: '#808080' },
        { id: 'GN', code: 'GN', name: 'Green Black',     upColor: '#00FF00', downColor: '#000000' },
        { id: 'BR', code: 'BR', name: 'Blue Red',        upColor: '#3674D9', downColor: '#E13255' },
        { id: 'PG', code: 'PG', name: 'Purple Gold',     upColor: '#9C27B0', downColor: '#FFC107' },
        { id: 'IC', code: 'IC', name: 'Institutional',   upColor: '#000000', downColor: '#3533CD' }
    ];

    var byId = {};
    var ids = [];
    presets.forEach(function (p) {
        byId[p.id] = p;
        ids.push(p.id);
    });

    function getPreset(id) { return byId[id] || presets[0]; }
    function getIds() { return ids.slice(); }
    function getNextId(currentId) {
        var idx = ids.indexOf(currentId);
        return ids[(idx + 1) % ids.length];
    }

    global.ThemePresets = byId;
    global.ThemePresets.getPreset = getPreset;
    global.ThemePresets.getIds = getIds;
    global.ThemePresets.getNextId = getNextId;
})(typeof window !== 'undefined' ? window : this);
